<?php 

$done = false;
$error = false;

if( $_SERVER['REQUEST_METHOD'] == 'POST')
{

    if (empty($_POST['host']) && empty($_POST['user']) && empty($_POST['name']) && empty($_POST['pass'])) 
    {
        $error = "empty";
    }
    else
    {
        $data = array(
                'db_host' => trim($_POST['host']),
                'db_user' => trim($_POST['user']),
                'db_pass' => trim($_POST['pass']),
                'db_name' => trim($_POST['name']),
            );
        try {

            // Setup database connection
            $conn = new PDO("mysql:host=".$data['db_host'].";dbname=".$data['db_name'],$data['db_user'],$data['db_pass']);
            $conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);

        }
        catch(PDOException $e){
            $error = "connect";
        }

        if ($error == false) 
        {

            $content = '<?php
            $db_config = array(
                "host" => "db_host",
                "user" => "db_user",
                "pass" => "db_pass",
                "name" => "db_name"
            );';
            foreach($data as $from => $to)
            {
                $content = str_replace($from, $to, $content);
            }

            if (file_put_contents('../lib/database.php', $content)) 
            {
            
                // parse SQL, run only commands
                $dump = file_get_contents('data.sql');
                preg_match_all("/(?:^|\n)([A-Z][^;]+);/", $dump, $sql_data);
                
                // Dump the data into database
                foreach($sql_data[1] as $query)
                {
                    $conn->query($query);
                }
                $done = true;
            
            }
            else
            {
                $error = "write";
            }
        }
    }
}


?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Installer - WebScanUp</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="HTML5 Admin Simplenso Template">
  <meta name="author" content="ahoekie">

  <!-- Stylesheets -->
  <link href="../admincp/assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="../admincp/assets/css/bootstrap-responsive.min.css" rel="stylesheet">
  <link href="../admincp/assets/css/style.css" rel="stylesheet">
  
  <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
  <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
  <![endif]-->

</head>
<body>


<div class="container">

<?php 
if($done)
{
?>

    <div class="well span4 offset3">
        
        <h3>All right sparky! All done</h3>
        <p>Proceed to your admin area and update your website domain and other information.</p>
        <p>Your temporary logins are: </p>
        <ul>
            <li>Username: admin</li>
            <li>Password: pass</li>
        </ul>
        <p>Do remember to update them once you have logged in</p>
    </div>
    <?php
}
else
{
?>

    <form class="form-horizontal span4 offset3" action="" method="POST">
        <fieldset>
            <div id="legend" class="page-header">
                <legend class="">WebScanUp Installer</legend>
            </div>
            
            <?php 
            if ($error) 
            {
            ?>   
                <div class="alert alert-error">
                    <a class="close">×</a>
                    <strong>Error</strong>
            <?php
                switch ($error) {
                    case 'empty':
                        echo "Please enter all details";
                        break;

                    case 'connect':
                        echo "Unable to connect with database. Please cross check your login details.";
                        break;

                    case 'write':
                        echo "Unable to write data in database config file. Please add the below data in 'lib/database.php' and import 'install/data.sql' file in your database.<br><br><pre>".htmlentities($content, ENT_QUOTES)."</pre>";
                        break;
                    
                    default:
                        # code...
                        break;
                }
                ?>
                </div>
            <?php 
            }
            ?>
            <div class="control-group">
                <!-- Username -->
                <label class="control-label" for="host">Database Host</label>
                <div class="controls">
                    <input type="text" id="host" name="host" value="localhost" class="input-xlarge">
                </div>
            </div>

            <div class="control-group">
                <!-- Username -->
                <label class="control-label" for="name">Database Name</label>
                <div class="controls">
                    <input type="text" id="name" name="name" placeholder="pingclan" class="input-xlarge">
                </div>
            </div>

            <div class="control-group">
                <!-- Username -->
                <label class="control-label" for="user">Database user</label>
                <div class="controls">
                    <input type="text" id="user" name="user" placeholder="root" class="input-xlarge">
                </div>
            </div>
             
            <div class="control-group">
                <!-- Password-->
                <label class="control-label" for="pass">Database Password</label>
                <div class="controls">
                    <input type="password" id="pass" name="pass" placeholder="pass" class="input-xlarge">
                </div>
            </div>
             
             
            <div class="control-group">
                <!-- Button -->
                <div class="controls">
                    <button class="btn btn-success">Install</button>
                </div>
            </div>
        </fieldset>
    </form>

<?php
}
?>
</div>

  <!-- javascript Templates
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="http://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.min.js"></script>
    <script src="../admincp/assets/js/bootstrap.min.js"></script>

  </body>
</html>